#ifndef __SMAC_APP_H
#define __SMAC_APP_H

#include "hprfgw_config.h"
#include "hprfgw_rfNwkMacInterface.h"
#include "smac_pub_def.h"
#if defined (OS_WINCE)
 #include <bsp.h>
#endif

//#define TXTEST
#undef TXTEST


#define INITIAL_STATE 0
#define IDLE_STATE 1
#define WAITING_FOR_ACK 2
#define RECEIVER_ALWAYS_ON 3
#define TRANSMIT_ACK 4
#define TRANSMIT_DATA 5
#define TIMEOUT_STATE 6
#define RE_TRANSMIT_DATA 7
#define RESET_STATE 8
#define SHUTDOWN_STATE 9
#define WAITING_FOR_RX 10
#define SEND_APP_ACK 11
#define RECEIVER_ON_WTO 12
#define TXACK_WTO 13
//#define CHANNEL_NUMBER    19
//#define CHANNEL_NUMBER    26
//#define OUTPUT_POWER        MAX_POWER
//#define OUTPUT_POWER        11
#define SMAC_TIMEOUT_PERIOD 0x500
#define SMAC_IMMEDIATE_TIMEOUT_PERIOD 50
#define SMAC_RETRY_COUNT 3


BOOL AreBytesDiff(UINT8 *lhs, UINT8 *rhs, UINT16 numbytes);
void RF_Intfc_Init(UINT8 channel, UINT16 Power, UINT8 *deviceExtAddr, UINT8 CCAEnergyThreshold, UINT8 PowerCompOffset);
void RF_Intfc_Deinit(void);
UINT32 RF_Intfc_GetVersion(void);
void MLMEMC13192ResetIndication(void);
int PhyReadCmd  (int ignore, char *cmd);
int PhyWriteCmd (int ignore, char *cmd);
void Smac_clearCounters(void);
int Smac_isResetDone(void);
#if defined (OS_NUCLEUS)
 void TxTask(unsigned long argc, void *argv );
 void RxTask(unsigned long argc, void *argv );
#elif defined (OS_WINCE)
 DWORD TxTask(VOID* pContext );
 DWORD RxTask(VOID* pContext );
#endif
int SetPIBAttCmd (int ignore, char *cmd);
// MNT - 5/7/2007 - Added the following functions to mimic the Freescale stack
void MacPhyInit_WriteExtAddress
(
  uint8_t *pExtendedAddress // A pointer to the 8 byte IEEE address. The address is
                            // copied into local MAC RAM.
);
uint8_t *MacPhyInit_ReadExtAddress(void);
void SMAC_SM_TurnOnRxWTO(UINT32 timeout);
void SMAC_SM_ResetPhy_And_Nack(void);
UINT8 GetRFPowerTableIndex(void);
extern void SMAC_MCUInit(void);
extern BOOL SMAC_IsRFChipValid(void);

/// \review - Check to make sure that the largest message is actually an MCPS
/// message
#define MAX_TX_MESSAGE_SIZE         (sizeof(nwkToMcpsMessage_t) + 127)
#define MAX_RX_MESSAGE_SIZE         (sizeof(mcpsToNwkMessage_t) + 127)
#ifndef RF_TASKS_BASE_PRIORITY
 #if defined (OS_NUCLEUS)
  #pragma info "!!!!Pass in the RF_TASKS_BASE_PRIORITY using the make file!!!!"
 #endif
#endif

#define TRX_TASK_PRIORITY           RF_TASK_PRIORITY(RF_TASKS_BASE_PRIORITY, 3)
#define TRX_TASK_STACK_BYTES        (16*1024)
/// \review - If the message sizes change these will have to change!!!
#define TRX_TASK_TORF_QUEUE_SIZE    (4 * 1024 * sizeof(Rf_802_15_MAC_TO_SMAC_Frame_struct))
#define TRX_TASK_FROMRF_QUEUE_SIZE  (4 * 1024 * sizeof(Rf_802_15_MAC_Data_Frame_struct))

// MNT - 10/18/2007 - Added an event group to indicate to the task that transmit was done
#if defined (OS_NUCLEUS)
typedef struct
{
    NU_TASK task;
    UINT8 stack[TRX_TASK_STACK_BYTES];
    NU_EVENT_GROUP events;
    NU_PIPE toRFPipe;
    NU_PIPE fromRFPipe;
    NU_EVENT_GROUP txEvent;
} TXRXTASKDATA;
extern TXRXTASKDATA TxRxTask;

#define RF_TRX_RX_PACKET           0x00000001
#define RF_TRX_TX_PACKET           0x00000002
#define RF_TRX_TX_RETX             0x00000004
#define RF_TRX_TX_TIMEOUT          0x00000008
#define RF_TRX_RX_ON               0x00000010

#define RF_TX_TXDONE               0x00000001

#elif defined (OS_WINCE)
/* Events work in a different ways in Windows CE, these are index to an array of events */
/* These are the events for hEvents below */
#define RF_TRX_RX_PACKET			0
#define RF_TRX_TX_PACKET			1
#define RF_TRX_TX_RETX				2
#define RF_TRX_TX_TIMEOUT			3
#define RF_TRX_RX_ON				4

#define RF_TRX_EVENTS				5	/* <<<<----  Update this number if you add more event indexes */

/* These are the events for hTxEvents below */
#define RF_TX_TXDONE				1

typedef struct
{
    HANDLE task;
    HANDLE hEvents[RF_TRX_EVENTS];
    HANDLE hWriteHandleToRFPipe;
	HANDLE hReadHandleToRFPipe;
    HANDLE hWriteHandleFromRFPipe;
	HANDLE hReadHandleFromRFPipe;
    HANDLE hTxEvent;
} TXRXTASKDATA;
extern TXRXTASKDATA TxRxTask;
#elif defined (OS_LINUX)

/* TODO: Remove references to wince. */
/* Events work in a different ways in Windows CE, these are index to an array of events */
/* These are the events for hEvents below */
#define RF_TRX_RX_PACKET           0x00000001
#define RF_TRX_TX_PACKET           0x00000002
#define RF_TRX_TX_RETX             0x00000004
#define RF_TRX_TX_TIMEOUT          0x00000008
#define RF_TRX_RX_ON               0x00000010

#define RF_TRX_EVENTS				5	/* <<<<----  Update this number if you add more event indexes */

/* These are the events for hTxEvents below */
#define RF_TX_TXDONE				1

typedef struct
{
	DM_RESOURCE_HANDLE task;
	//DM_RESOURCE_HANDLE hEvents[RF_TRX_EVENTS];
	DM_RESOURCE_HANDLE events;
	DM_RESOURCE_HANDLE hHandleToRFPipe;
	DM_RESOURCE_HANDLE hHandleFromRFPipe;
	DM_RESOURCE_HANDLE hTxEvent;
} TXRXTASKDATA;
extern TXRXTASKDATA TxRxTask;
#endif


#if defined (OS_NUCLEUS)
 extern NU_MEMORY_POOL  System_Memory;
#endif
extern volatile int gi8AppStatus;
extern BOOL Smac_BroadcastTxInProgress;
extern BOOL Smac_PhyInitialized;
extern BOOL Smac_ResetGeneratedByProcessor;

// MNT - 6/16/2008 - Added variables to Timestamp reception of packet to allow 
// upper layers to reset PHY if needed
extern BOOL   g_bPacketRxReset;
extern UINT32 g_u32PacketRxTime;

UINT32 Smac_getLastPktRxTime(void);
BOOL Smac_rxPktSinceReset(void);


#define SMAC_SM_DEBUG (0)

#define SMAC_SM_DEBUG_NUMENTRIES    (10*1024)
extern UINT16 SMAC_SM_Debug_State[SMAC_SM_DEBUG_NUMENTRIES];
extern UINT32 SMAC_SM_Debug_Timestamp[SMAC_SM_DEBUG_NUMENTRIES];
extern UINT32 SMAC_SM_Debug_State_Ctr;

#if SMAC_SM_DEBUG
#if defined (OS_NUCLEUS)
  extern volatile unsigned long TMD_System_Clock;
  #pragma info "This should be changed if the processor changes!!!"
  #define NUCLEUS_TIMER_VAL (volatile unsigned short *)(0x40000000 + 0x150004)
  #define CURRENT_TIME_STAMP \
      (((TMD_System_Clock & 0x00007FFF) << 16) | (unsigned short)(0xFFFF-((*NUCLEUS_TIMER_VAL) & 0xFFFF)))
#elif defined (OS_WINCE)
  // Use this define in case you want to use the micro-second time stamp too.
  // But the macro below needs to be re-worked for an accurate time stamps.
  //#define SMAC_SM_DEBUG_TIMESTAMP_US  (1)

  #ifdef SMAC_SM_DEBUG_TIMESTAMP_US
  extern OMAP_GPTIMER_REGS *	pSmacDebugTimerReg;
  __inline DWORD GetOsTickTimerValue()
  {
      /* Experiment showed that this timer counts at a rate
      of about 30us (1 count = 30us) */
      return (INREG32(&pSmacDebugTimerReg->TCRR));
  }
  #endif

  #define NUCLEUS_TIMER_VAL (GetOsTickTimerValue())
  #ifdef SMAC_SM_DEBUG_TIMESTAMP_US
    // Note that the counter is a upward counter.
    // This has to be re-worked if needed. 15 bits from OS clock tick is not sufficient
    // because 1 count is 1ms, and 15 bits only can give up to 32seconds. And we don't
    // need 16 bits from the OS timer since each count represents 30us. This has to be
    // carefully done incase we need the timestamp in microseconds in future.
    #define CURRENT_TIME_STAMP \
         (((OS_RetrieveClock() & 0x00007FFF) << 16) | (unsigned short)(NUCLEUS_TIMER_VAL & 0xFFFF))
  #else
    // Just use the OS clock tick
    #define CURRENT_TIME_STAMP (OS_RetrieveClock())
  #endif

#endif //#elif defined (OS_WINCE)

#if defined(OS_LINUX)

  /* These are dangerous, shouldn't be used as part of an expression or if statement without braces. */

  #define SMAC_LOG_DEBUG_STATE_RAW(STATE, TIMESTAMP) \
        (SMAC_SM_Debug_State_Ctr = (SMAC_SM_Debug_State_Ctr+1)%SMAC_SM_DEBUG_NUMENTRIES); \
        trace_printk("%lu - %hx - %lums\n", SMAC_SM_Debug_State_Ctr, STATE, TIMESTAMP);

  #define SMAC_LOG_DEBUG_STATE(STATE, EVENTTYPE) \
        (SMAC_SM_Debug_State_Ctr = (SMAC_SM_Debug_State_Ctr+1)%SMAC_SM_DEBUG_NUMENTRIES); \
        trace_printk("%lu - %hx - %s - %lums\n", SMAC_SM_Debug_State_Ctr, STATE, #EVENTTYPE, HwGetMsec())

  #define SMAC_LOG_DEBUG_STATE2(STATE) \
        SMAC_LOG_DEBUG_STATE_RAW((STATE), (0x80000000 | HwGetMsec()) )


#else
  #define SMAC_LOG_DEBUG_STATE_RAW(STATE, TIMESTAMP) \
    SMAC_SM_Debug_State[(SMAC_SM_Debug_State_Ctr)%SMAC_SM_DEBUG_NUMENTRIES] = STATE; \
    SMAC_SM_Debug_Timestamp[(SMAC_SM_Debug_State_Ctr++)%SMAC_SM_DEBUG_NUMENTRIES] = TIMESTAMP;

  #define SMAC_LOG_DEBUG_STATE(STATE, EVENTTYPE) \
    SMAC_LOG_DEBUG_STATE_RAW((STATE | (EVENTTYPE << 8)), (HwGetMsec()))

  #define SMAC_LOG_DEBUG_STATE2(STATE) \
    SMAC_LOG_DEBUG_STATE_RAW((STATE), (0x80000000 | HwGetMsec()) )

#endif


typedef enum 
{
  SMAC_SM_DEBUG_EVENT_MCPS_TXPKT = 0x0,
  SMAC_SM_DEBUG_EVENT_RST_IND = 0x1,
  SMAC_SM_DEBUG_EVENT_MCPSD_IND_TIMEOUT = 0x2,
  SMAC_SM_DEBUG_EVENT_MCPSD_IND_TIMEOUT_APP_ACK = 0x3,
  SMAC_SM_DEBUG_EVENT_MCPSD_IND_RXPKT = 0x4,
  SMAC_SM_DEBUG_EVENT_MCPSD_IND_PHYTIMEOUT = 0x5,
  SMAC_SM_DEBUG_EVENT_RXON_AFTER_RST = 0x6,
  SMAC_SM_DEBUG_EVENT_TXDATA_RXDISFAILED = 0x7,
  SMAC_SM_DEBUG_EVENT_TXDATA_DONETX = 0x8,
  SMAC_SM_DEBUG_EVENT_RETXDATA_RXDISFAILED = 0x9,
  SMAC_SM_DEBUG_EVENT_RETXDATA_DONETX = 0xA,
  SMAC_SM_DEBUG_EVENT_TXACK = 0xB,
  SMAC_SM_DEBUG_EVENT_APP_ACK_DONE = 0xC,
  SMAC_SM_DEBUG_EVENT_TIMEOUTSTATE_RETR = 0xD,
  SMAC_SM_DEBUG_EVENT_TIMEOUTSTATE_GIVEUP = 0xE,
  SMAC_SM_DEBUG_EVENT_INSM = 0xF,
  SMAC_SM_DEBUG_EVENT_MCPSD_IND_BADPKT = 0x10,
  SMAC_SM_DEBUG_EVENT_MCPSD_IND_BADPANID = 0x11,
  SMAC_SM_DEBUG_EVENT_MCPSD_IND_BADUID = 0x12,
  SMAC_SM_DEBUG_EVENT_APP_REQ_SMAC_RST = 0x13,
  SMAC_SM_DEBUG_EVENT_MCPSD_IND_INVPKT_TIMEOUT = 0x14,
  SMAC_SM_DEBUG_EVENT_MCPSD_IND_VALIDPKT_TIMEOUT = 0x15,
  SMAC_SM_DEBUG_EVENT_TXACK_WTO_RETR = 0x16,
  SMAC_SM_DEBUG_EVENT_TXACK_WTO_GIVEUP = 0x17,
  SMAC_SM_DEBUG_EVENT_TXDATA_FAILED_RETX = 0x18,
  SMAC_SM_DEBUG_EVENT_TXDATA_FAILED_TIMEOUT = 0x19,
  SMAC_SM_DEBUG_EVENT_RETXDATA_FAILED_RETX = 0x1A,
  SMAC_SM_DEBUG_EVENT_RETXDATA_FAILED_TIMEOUT = 0x1B,
  SMAC_SM_DEBUG_EVENT_TIMEOUT_BUT_PKTRCVD = 0x1C,
  SMAC_SM_DEBUG_EVENT_MCPSD_IND_RXPKTBEFOREACK = 0x1D,
  SMAC_SM_DEBUG_EVENT_MCPSD_IND_DELAYDONE = 0x1E,
  SMAC_SM_DEBUG_EVENT_TELEC_START = 0x1F,
  SMAC_SM_DEBUG_EVENT_TELEC_DONE = 0x20,
  SMAC_SM_DEBUG_EVENT_STARTRX_WTO = 0x21,
  SMAC_SM_DEBUG_EVENT_RX_WTO_STARTED = 0x22,
  SMAC_SM_DEBUG_EVENT_IDLE_HISR_RXWTO = 0x23,
  SMAC_SM_DEBUG_EVENT_IDLE_HISR_LOLOCKED_TXMODE = 0x24,
  SMAC_SM_DEBUG_EVENT_IDLE_HISR_CCATXDONE = 0x25,
  SMAC_SM_DEBUG_EVENT_IDLE_HISR_VALIDPKT = 0x26,
  SMAC_SM_DEBUG_EVENT_IDLE_HISR_LOLOCKED = 0x27,
  SMAC_SM_DEBUG_EVENT_IDLE_HISR_TXIRQ = 0x28,
  SMAC_SM_DEBUG_EVENT_RXWTO_PLMESETSTATE = 0x29,
  SMAC_SM_DEBUG_EVENT_RX_PLMESETSTATE = 0x2A,
  SMAC_SM_DEBUG_EVENT_IDLE_PLMESETSTATE = 0x2B,
  SMAC_SM_DEBUG_EVENT_TX_PLMESETSTATE = 0x2C,
  SMAC_SM_DEBUG_EVENT_MCPSD_IND_RXMODEDONE = 0x2D,
  SMAC_SM_DEBUG_EVENT_MCPSD_IND_VALIDPKTRXMODEDONE = 0x2E,
  SMAC_SM_DEBUG_EVENT_HISR_REQ_SMAC_RST = 0x2F,
  SMAC_SM_DEBUG_EVENT_TX_BROADCASTPKT = 0x30,
  SMAC_SM_DEBUG_EVENT_TX_STARTCCA = 0x31,
  SMAC_SM_DEBUG_EVENT_TX_ENDCCA = 0x32,
  SMAC_SM_DEBUG_EVENT_TX_CCA_CHBUSY = 0x33,
  SMAC_SM_DEBUG_EVENT_HISR_TMRWITHCCAVALIDRESET = 0x34,
  SMAC_SM_DEBUG_EVENT_CHANBUSY_RESET = 0x35
}SMAC_SM_DEBUG_EVENT_ENUM;

#else // SMAC_SM_DEBUG

#define SMAC_LOG_DEBUG_STATE_RAW(STATE, TIMESTAMP)
#define SMAC_LOG_DEBUG_STATE(STATE, EVENTTYPE)
#define SMAC_LOG_DEBUG_STATE2(STATE)

#endif // SMAC_SM_DEBUG


// MNT - 6/11/2008 - Do not allow changing of state if we are in reset or idle state
// Any place that needs to override this behavior will set the state manually instead
// of using this macro. i.e. RESET and IDLE states will be set without the macro
#define SMAC_SET_APP_STATE(status) \
  if ( (gi8AppStatus != RESET_STATE) && (gi8AppStatus != IDLE_STATE) )\
  { \
    gi8AppStatus = status; \
  }


extern BOOL Smac_rxWithAckFlag;
extern UINT32 Smac_rxWithAckCount;


extern tTxPacket Smac_gsAckPacket;
extern tRxPacket Smac_gsRxPacket;


// MNT - 1/21/2008 - The following signature is written to the PHY GPIO for FCC verification
#define   SMAC_FCC_SIGNATURE        0x5
#define   SMAC_GPIO_CONFIG_BITS     0x0300

/**
 *
 * \date               04-26-2007
 *
 * \author             mtalreja
 *
 * \brief              Structure to hold the MAC pib values
 *
 * \detail
 *
 **/
typedef struct _Rf_Smac_802_PIB_struct
{
  UINT8         logicalChannel;
  UINT8         isRxOnWhenIdle;
  UINT16        panId;
  UINT16        shortAddress;
  UINT8         shouldPermitAssociate;
  UINT16        coordShortAddress;
  UINT8         coordExtendedAddress[8];
  UINT8         promiscuousMode;
  UINT8         rfDisabled;     // false by default
  UINT8         minBE;                      // Minimum Back off exponent. Default 3
  UINT8         maxCSMABackoffs;            // Maximum CSMA backoffs. Default 4
}Rf_Smac_802_PIB_struct;

extern Rf_Smac_802_PIB_struct Rf_Smac_802_PIB;

#define SMAC_802_PIB_MINBE_DEFAULT              (0x3)
#define SMAC_802_PIB_MAXBE                      (0x5)
#define SMAC_802_PIB_MAXCSMABOFF_DEFAULT        (0x4)
#define SMAC_802_PIB_BACKOFF_PERIOD_INUS        (320)

/**
 *
 * \date               04-26-2007
 *
 * \author             mtalreja
 *
 * \brief              Structure to hold the PHY param values
 *
 * \detail
 *
 **/
typedef struct _Rf_Smac_802_PHYParams_struct
{
  UINT8         deviceExtendedAddress[8];
  UINT8         outputPower;
  UINT8         PowerCompOffset;
  UINT8         CCAEnergyThreshold;
}Rf_Smac_802_PHYParams_struct;

extern Rf_Smac_802_PHYParams_struct Rf_Smac_802_PHYParams;

/**
 *
 * \date               04-26-2007
 *
 * \author             mtalreja
 *
 * \brief              Structure to hold the data structures needed between the RF application
 *                     and the SMAC code
 *
 * \detail
 *
 **/
#if defined (OS_NUCLEUS)
typedef struct _Rf_Smac_Shim_Struct
{
  NU_PIPE  MlmeNwkInputQueue;
  NU_PIPE  McpsNwkInputQueue;
  NU_PIPE  AspNwkInputQueue;
  NU_TASK  task;
  UINT8    stack[SMAC_SHIM_TASK_STACK_BYTES];

}Rf_Smac_Shim_Struct;
#elif defined (OS_WINCE)
typedef struct _Rf_Smac_Shim_Struct
{
  HANDLE   hWriteMlmeNwkInputQueue;
  HANDLE   hReadMlmeNwkInputQueue;

  HANDLE   hWriteMcpsNwkInputQueue;
  HANDLE   hReadMcpsNwkInputQueue;

  HANDLE   hWriteAspNwkInputQueue;
  HANDLE   hReadAspNwkInputQueue;

  HANDLE   task;
}Rf_Smac_Shim_Struct;
#elif defined (OS_LINUX)
typedef struct _Rf_Smac_Shim_Struct
{
  DM_RESOURCE_HANDLE   hMlmeNwkInputQueue;
//  DM_RESOURCE_HANDLE   hReadMlmeNwkInputQueue;

  DM_RESOURCE_HANDLE   hMcpsNwkInputQueue;
//  DM_RESOURCE_HANDLE   hReadMcpsNwkInputQueue;

  DM_RESOURCE_HANDLE   hAspNwkInputQueue;
//  DM_RESOURCE_HANDLE   hReadAspNwkInputQueue;

  DM_RESOURCE_HANDLE   task;
}Rf_Smac_Shim_Struct;
#endif

extern Rf_Smac_Shim_Struct Rf_Smac_Shim;


/* TODO: What goes here? It's used by the upper layers but is only defined by
 * Windows, not for Nucleus.
 */
typedef struct
{
} hprf_hw_dev;

//TODO: right place to put this?
extern hprf_hw_dev *pHPRDevice;

#endif // __SMAC_APP_H
